/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec2f;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.CustomNpcs;
import noppes.npcs.ModelPartConfig;
import noppes.npcs.api.util.IModelRenderer;
import noppes.npcs.client.model.ModelNpcAlt;
import noppes.npcs.client.model.animation.AddedPartConfig;
import noppes.npcs.client.model.animation.AnimationFrameConfig;
import noppes.npcs.client.renderer.ModelBuffer;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.entity.data.DataAnimation;
import noppes.npcs.items.CustomArmor;
import org.lwjgl.opengl.GL11;

public class ModelRendererAlt
extends ModelRenderer
implements IModelRenderer {
    public EnumParts part;
    public int partId;
    public int parentPartId = -1;
    private final Map<Integer, PositionTextureVertex> vs = new HashMap<Integer, PositionTextureVertex>();
    private final Map<Integer, TexturedQuad> quads = new HashMap<Integer, TexturedQuad>();
    private final Vec2f[] tvs = new Vec2f[8];
    public float x;
    public float y;
    public float z;
    public float xe;
    public float ye0;
    public float ye1;
    public float ye2;
    public float ze;
    public float dx;
    public float dy0;
    public float dy1;
    public float dy2;
    public float dz;
    public float u;
    public float v;
    private int displayList;
    private int displayOBJListUp;
    private int displayOBJListDown;
    public float rotateAngleX1 = 0.0f;
    public float rotateAngleY1 = 0.0f;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public float scaleZ = 1.0f;
    public float offsetAnimX = 0.0f;
    public float offsetAnimY = 0.0f;
    public float offsetAnimZ = 0.0f;
    private boolean normalTop = false;
    public boolean isNormal = false;
    public final boolean baseNormal;
    public boolean smallArms;
    public boolean isAnimPart;
    private float r = 1.0f;
    private float g = 1.0f;
    private float b = 1.0f;
    private float al = 0.0f;
    private final float[] baseRotationPoint;
    public ResourceLocation textureLocation = null;
    public ResourceLocation objLocationUp = null;
    public ResourceLocation objLocationDown = null;
    public boolean isArmor;

    public ModelRendererAlt(ModelBase model, EnumParts enumPart, int textureU, int textureV, boolean normal) {
        super(model, textureU, textureV);
        this.part = enumPart;
        this.partId = enumPart.patterns;
        this.u = textureU;
        this.v = textureV;
        this.isNormal = normal;
        this.baseNormal = normal;
        this.baseRotationPoint = new float[]{this.field_78800_c, this.field_78797_d, this.field_78798_e};
    }

    public ModelRendererAlt(ModelBase baseModel, AddedPartConfig addedPartConfig) {
        super(baseModel, addedPartConfig.textureU, addedPartConfig.textureV);
        this.part = EnumParts.CUSTOM;
        this.partId = addedPartConfig.id;
        this.parentPartId = addedPartConfig.parentPart;
        this.u = addedPartConfig.textureU;
        this.v = addedPartConfig.textureV;
        this.isNormal = addedPartConfig.isNormal;
        this.baseNormal = addedPartConfig.isNormal;
        this.textureLocation = addedPartConfig.location;
        this.objLocationUp = addedPartConfig.objUp;
        this.objLocationDown = addedPartConfig.objDown;
        if (this.objLocationUp != null) {
            this.displayOBJListUp = ModelBuffer.getDisplayList(this.objLocationUp, null, null);
        }
        if (this.objLocationDown != null) {
            this.displayOBJListDown = ModelBuffer.getDisplayList(this.objLocationDown, null, null);
        }
        this.baseRotationPoint = new float[]{this.field_78800_c, this.field_78797_d, this.field_78798_e};
        this.setBox(addedPartConfig.pos[0], addedPartConfig.pos[1], addedPartConfig.pos[2], addedPartConfig.size[0], addedPartConfig.size[1], addedPartConfig.size[2], addedPartConfig.size[3], addedPartConfig.size[4], 0.0f);
        this.func_78793_a(addedPartConfig.rot[0], addedPartConfig.rot[1], addedPartConfig.rot[2]);
    }

    public ModelRendererAlt(ModelBase model) {
        super(model);
        this.baseNormal = true;
        this.baseRotationPoint = new float[]{this.field_78800_c, this.field_78797_d, this.field_78798_e};
    }

    public void setBox(float x, float y, float z, float dx, float dy0, float dy1, float dy2, float dz, float wear) {
        this.xe = x + dx + wear;
        this.ye0 = y + dy0;
        this.ye1 = y + dy0 + dy1;
        this.ye2 = y + dy0 + dy1 + dy2 + wear;
        this.ze = z + dz + wear;
        this.x = x - wear;
        this.y = y - wear;
        this.z = z - wear;
        this.dx = dx;
        this.dz = dz;
        this.dy0 = dy0;
        this.dy1 = this.dy0 + dy1;
        this.dy2 = this.dy1 + dy2;
        if (this.field_78809_i) {
            float f3 = this.xe;
            this.xe = x;
            this.x = f3;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_78794_c(float scale) {
        if (this.offsetAnimX != 0.0f || this.offsetAnimY != 0.0f || this.offsetAnimZ != 0.0f || this.smallArms) {
            float ox = this.offsetAnimX;
            if (this.smallArms) {
                ox += this.part == EnumParts.ARM_LEFT ? -0.020833f : 0.020833f;
            }
            GlStateManager.func_179109_b((float)ox, (float)this.offsetAnimY, (float)this.offsetAnimZ);
        }
        GlStateManager.func_179109_b((float)(this.field_78800_c * scale), (float)((this.field_78797_d + this.offsetAnimY) * scale), (float)((this.field_78798_e + this.offsetAnimZ) * scale));
        if (this.field_78808_h != 0.0f) {
            GlStateManager.func_179114_b((float)(this.field_78808_h * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (this.field_78796_g != 0.0f) {
            GlStateManager.func_179114_b((float)(this.field_78796_g * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (this.field_78795_f != 0.0f) {
            GlStateManager.func_179114_b((float)(this.field_78795_f * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (this.scaleX != 1.0f || this.scaleY != 1.0f || this.scaleZ != 1.0f || this.smallArms) {
            float sx = this.scaleX;
            if (this.smallArms) {
                sx *= this.dx / (this.dx + 1.0f);
            }
            GlStateManager.func_179152_a((float)sx, (float)this.scaleY, (float)this.scaleZ);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_78785_a(float scale) {
        if (this.field_78807_k || !this.field_78806_j) {
            return;
        }
        GlStateManager.func_179094_E();
        this.func_78794_c(scale);
        if (this.al != 0.0f) {
            GlStateManager.func_179131_c((float)this.r, (float)this.g, (float)this.b, (float)this.al);
        } else {
            GlStateManager.func_179131_c((float)this.r, (float)this.g, (float)this.b, (float)1.0f);
        }
        if (this.textureLocation != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.textureLocation);
        }
        if (this.displayOBJListUp > 0 || this.displayOBJListDown > 0) {
            this.objDraw();
        } else {
            this.clearData();
            if (this.isNormal || !CustomNpcs.ShowJoints || this.rotateAngleX1 == 0.0f && this.rotateAngleY1 == 0.0f) {
                this.simpleDraw(scale);
            } else {
                this.rotateTop();
                this.drawJoint(scale);
            }
        }
        if (this.field_78805_m != null && !this.field_78805_m.isEmpty()) {
            ArrayList<ModelRenderer> del = new ArrayList<ModelRenderer>();
            for (ModelRenderer model : this.field_78805_m) {
                if (model instanceof ModelRendererAlt) {
                    ((ModelRendererAlt)model).checkBacklightColor(this.r, this.g, this.b);
                    if (((ModelRendererAlt)model).part == EnumParts.CUSTOM) {
                        del.add(model);
                    }
                }
                model.func_78785_a(scale);
            }
            for (ModelRenderer model : del) {
                this.field_78805_m.remove(model);
            }
        }
        GlStateManager.func_179121_F();
    }

    private void clearData() {
        this.vs.clear();
        this.quads.clear();
    }

    private void rotateTop() {
        if (this.rotateAngleY1 == 0.0f) {
            if (!this.normalTop) {
                this.tvs[0] = new Vec2f(this.x, this.z);
                this.tvs[1] = new Vec2f(this.xe, this.z);
                this.tvs[2] = new Vec2f(this.xe, this.ze);
                this.tvs[3] = new Vec2f(this.x, this.ze);
                this.tvs[4] = new Vec2f(this.x, this.z);
                this.tvs[5] = new Vec2f(this.xe, this.z);
                this.tvs[6] = new Vec2f(this.xe, this.ze);
                this.tvs[7] = new Vec2f(this.x, this.ze);
                this.normalTop = true;
            }
        } else {
            float limit = 1.5707964f;
            if (this.rotateAngleY1 > limit) {
                this.rotateAngleY1 = limit;
            }
            if (this.rotateAngleY1 < -limit) {
                this.rotateAngleY1 = -limit;
            }
            double cos = Math.cos(-this.rotateAngleY1);
            double sin = Math.sin(-this.rotateAngleY1);
            Vec2f xMzM = this.rotate(new Vec2f(this.x + (this.xe - this.x) / 2.0f, this.z + (this.ze - this.z) / 2.0f), new Vec2f(this.x, this.z), cos, sin);
            Vec2f xNzM = this.rotate(new Vec2f(this.x + (this.xe - this.x) / 2.0f, this.z + (this.ze - this.z) / 2.0f), new Vec2f(this.xe, this.z), cos, sin);
            Vec2f xNzN = this.rotate(new Vec2f(this.x + (this.xe - this.x) / 2.0f, this.z + (this.ze - this.z) / 2.0f), new Vec2f(this.xe, this.ze), cos, sin);
            Vec2f xMzN = this.rotate(new Vec2f(this.x + (this.xe - this.x) / 2.0f, this.z + (this.ze - this.z) / 2.0f), new Vec2f(this.x, this.ze), cos, sin);
            this.tvs[0] = new Vec2f(xMzM.field_189982_i, xMzM.field_189983_j);
            this.tvs[1] = new Vec2f(xNzM.field_189982_i, xNzM.field_189983_j);
            this.tvs[2] = new Vec2f(xNzN.field_189982_i, xNzN.field_189983_j);
            this.tvs[3] = new Vec2f(xMzN.field_189982_i, xMzN.field_189983_j);
            this.tvs[4] = new Vec2f(xMzM.field_189982_i, xMzM.field_189983_j);
            this.tvs[5] = new Vec2f(xNzM.field_189982_i, xNzM.field_189983_j);
            this.tvs[6] = new Vec2f(xNzN.field_189982_i, xNzN.field_189983_j);
            this.tvs[7] = new Vec2f(xMzN.field_189982_i, xMzN.field_189983_j);
            this.normalTop = false;
        }
    }

    private void objDraw() {
        switch (this.part) {
            case HEAD: 
            case BODY: {
                GlStateManager.func_179109_b((float)0.0f, (float)1.5f, (float)0.0f);
                break;
            }
            case ARM_RIGHT: {
                GlStateManager.func_179109_b((float)0.3175f, (float)1.375f, (float)0.0f);
                break;
            }
            case ARM_LEFT: {
                GlStateManager.func_179109_b((float)-0.3175f, (float)1.375f, (float)0.0f);
                break;
            }
            case LEG_RIGHT: {
                GlStateManager.func_179109_b((float)0.125f, (float)0.75f, (float)0.0f);
                break;
            }
            case LEG_LEFT: {
                GlStateManager.func_179109_b((float)-0.115f, (float)0.75f, (float)0.0f);
                break;
            }
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        if (this.displayOBJListUp > 0) {
            if (this.textureLocation == null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            }
            GlStateManager.func_179148_o((int)this.displayOBJListUp);
        }
        if (this.displayOBJListDown > 0) {
            boolean isArm;
            if (this.rotateAngleX1 != 0.0f) {
                isArm = this.part.name().toLowerCase().contains("arm");
                float ofsY = this.dy2 - this.dy0;
                if (isArm) {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.75f, (float)0.0f);
                }
                float ofsZ = this.rotateAngleX1 * (this.dz / 2.0f) / (float)(-Math.PI);
                GlStateManager.func_179109_b((float)0.0f, (float)(ofsY * 0.0625f), (float)(ofsZ * 0.0625f));
                GlStateManager.func_179114_b((float)(this.rotateAngleX1 * 180.0f / (float)Math.PI), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)(ofsY * -0.0625f), (float)(ofsZ * -0.0625f));
                if (isArm) {
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.75f, (float)0.0f);
                }
            }
            if (this.rotateAngleY1 != 0.0f) {
                isArm = this.part.name().toLowerCase().contains("arm");
                float ofs = (this.part.name().toLowerCase().contains("right") ? -1.0f : 1.0f) * (isArm ? 0.375f : 0.125f);
                GlStateManager.func_179109_b((float)ofs, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(this.rotateAngleY1 * 180.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)(-ofs), (float)0.0f, (float)0.0f);
            }
            if (this.textureLocation == null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            }
            GlStateManager.func_179148_o((int)this.displayOBJListDown);
        }
        GlStateManager.func_179084_k();
    }

    private void simpleDraw(float scale) {
        if (this.displayList > 0) {
            GlStateManager.func_179148_o((int)this.displayList);
            if (this.field_78805_m != null) {
                for (ModelRenderer childModel : this.field_78805_m) {
                    childModel.func_78785_a(scale);
                }
            }
            return;
        }
        this.vs.put(0, new PositionTextureVertex(this.x, this.y, this.z, 0.0f, 0.0f));
        this.vs.put(1, new PositionTextureVertex(this.xe, this.y, this.z, 0.0f, 8.0f));
        this.vs.put(2, new PositionTextureVertex(this.xe, this.ye2, this.z, 8.0f, 8.0f));
        this.vs.put(3, new PositionTextureVertex(this.x, this.ye2, this.z, 8.0f, 0.0f));
        this.vs.put(4, new PositionTextureVertex(this.x, this.y, this.ze, 0.0f, 0.0f));
        this.vs.put(5, new PositionTextureVertex(this.xe, this.y, this.ze, 0.0f, 8.0f));
        this.vs.put(6, new PositionTextureVertex(this.xe, this.ye2, this.ze, 8.0f, 8.0f));
        this.vs.put(7, new PositionTextureVertex(this.x, this.ye2, this.ze, 8.0f, 0.0f));
        this.setQuard(0, this.vs.get(5), this.vs.get(1), this.vs.get(2), this.vs.get(6), this.u + this.dz + this.dx, this.v + this.dz, this.u + this.dz + this.dx + this.dz, this.v + this.dz + this.dy2);
        this.setQuard(1, this.vs.get(0), this.vs.get(4), this.vs.get(7), this.vs.get(3), this.u, this.v + this.dz, this.u + this.dz, this.v + this.dz + this.dy2);
        this.setQuard(2, this.vs.get(5), this.vs.get(4), this.vs.get(0), this.vs.get(1), this.u + this.dz, this.v, this.u + this.dz + this.dx, this.v + this.dz);
        this.setQuard(3, this.vs.get(2), this.vs.get(3), this.vs.get(7), this.vs.get(6), this.u + this.dz + this.dx, this.v + this.dz, this.u + this.dz + this.dx + this.dx, this.v);
        this.setQuard(4, this.vs.get(1), this.vs.get(0), this.vs.get(3), this.vs.get(2), this.u + this.dz, this.v + this.dz, this.u + this.dz + this.dx, this.v + this.dz + this.dy2);
        this.setQuard(5, this.vs.get(4), this.vs.get(5), this.vs.get(6), this.vs.get(7), this.u + this.dz + this.dx + this.dz, this.v + this.dz, this.u + this.dz + this.dx + this.dz + this.dx, this.v + this.dz + this.dy2);
        this.displayList = GLAllocation.func_74526_a((int)1);
        GlStateManager.func_187423_f((int)this.displayList, (int)4864);
        this.draw(scale);
        GL11.glEndList();
    }

    private void drawJoint(float scale) {
        boolean counterClockWise;
        boolean bl = counterClockWise = this.rotateAngleY1 <= 0.0f;
        if (this.isArmor && this.part != EnumParts.ARM_RIGHT && this.part != EnumParts.LEG_RIGHT) {
            counterClockWise = !counterClockWise;
        }
        this.vs.put(0, new PositionTextureVertex(this.x, this.y, this.z, 0.0f, 0.0f));
        this.vs.put(1, new PositionTextureVertex(this.xe, this.y, this.z, 0.0f, 8.0f));
        this.vs.put(2, new PositionTextureVertex(this.xe, this.y, this.ze, 8.0f, 8.0f));
        this.vs.put(3, new PositionTextureVertex(this.x, this.y, this.ze, 8.0f, 0.0f));
        int i = 0;
        this.setQuard(i++, this.vs.get(2), this.vs.get(3), this.vs.get(0), this.vs.get(1), this.u + this.dz, this.v, this.u + this.dz + this.dx, this.v + this.dz);
        float cos0 = (float)Math.cos(-this.rotateAngleX1 / 3.0f);
        float sin0 = (float)Math.sin(-this.rotateAngleX1 / 3.0f);
        float cos1 = (float)Math.cos(-this.rotateAngleX1 / 1.5f);
        float sin1 = (float)Math.sin(-this.rotateAngleX1 / 1.5f);
        float cos2 = (float)Math.cos(-this.rotateAngleX1);
        float sin2 = (float)Math.sin(-this.rotateAngleX1);
        float tan = (float)Math.tan(-this.rotateAngleX1 / 2.0f);
        if ((double)this.rotateAngleX1 <= -3.1415) {
            tan = 0.0f;
        }
        Vec2f cr = new Vec2f(this.ye0, this.rotateAngleX1 * -this.ze / (float)(-Math.PI));
        if (this.rotateAngleX1 < 0.0f) {
            Vec2f g0 = new Vec2f(cr.field_189982_i + (this.ze - cr.field_189983_j) * sin0 + (this.ye0 - cr.field_189982_i) * cos0, cr.field_189983_j + (this.ze - cr.field_189983_j) * cos0 - (this.ye0 - cr.field_189982_i) * sin0);
            Vec2f g1 = new Vec2f(cr.field_189982_i + (this.ze - cr.field_189983_j) * sin1 + (this.ye0 - cr.field_189982_i) * cos1, cr.field_189983_j + (this.ze - cr.field_189983_j) * cos1 - (this.ye0 - cr.field_189982_i) * sin1);
            Vec2f g2 = new Vec2f(cr.field_189982_i + (this.ze - cr.field_189983_j) * sin2 + (this.ye0 - cr.field_189982_i) * cos2, cr.field_189983_j + (this.ze - cr.field_189983_j) * cos2 - (this.ye0 - cr.field_189982_i) * sin2);
            float t = (this.z - cr.field_189983_j) * tan;
            Vec2f g3 = new Vec2f(this.ye0 + t, this.z);
            float d0 = (float)Math.hypot(g0.field_189982_i - g1.field_189982_i, g0.field_189983_j - g1.field_189983_j);
            float n0 = this.dy0 / (this.dy0 + d0 * 1.5f) * d0 * 1.5f;
            float n1 = (this.dy1 - this.dy0) / (this.dy1 - this.dy0 + d0 * 1.5f) * d0 * 1.5f;
            float dy00 = this.dy0 - n0;
            float dy01 = dy00 + n0 / 1.5f;
            float dy02 = this.dy0 + n1 / 3.0f;
            float dy03 = (this.dy0 + n1) * 0.85f;
            this.vs.put(4, new PositionTextureVertex(this.x, g3.field_189982_i, this.z, 0.0f, 0.0f));
            this.vs.put(5, new PositionTextureVertex(this.xe, g3.field_189982_i, this.z, 0.0f, 8.0f));
            this.vs.put(6, new PositionTextureVertex(this.xe, this.ye0, this.ze, 8.0f, 8.0f));
            this.vs.put(7, new PositionTextureVertex(this.x, this.ye0, this.ze, 8.0f, 0.0f));
            this.setQuard(i++, this.vs.get(1), this.vs.get(0), this.vs.get(4), this.vs.get(5), this.u + this.dz, this.v + this.dz, this.u + this.dz + this.dx, this.v + this.dz + this.dy0);
            this.setQuard(i++, this.vs.get(3), this.vs.get(2), this.vs.get(6), this.vs.get(7), this.u + 2.0f * this.dz + this.dx, this.v + this.dz, this.u + 2.0f * (this.dz + this.dx), this.v + this.dz + dy00);
            this.setQuard(i++, this.vs.get(1), this.vs.get(2), this.vs.get(6), this.vs.get(5), this.u + this.dz + this.dx, this.v + this.dz, this.u + 2.0f * this.dz + this.dx, this.v + this.dz, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + dy00, this.u + this.dz + this.dx, this.v + this.dz + this.dy0);
            this.setQuard(i++, this.vs.get(0), this.vs.get(3), this.vs.get(7), this.vs.get(4), this.u + this.dz, this.v + this.dz, this.u, this.v + this.dz, this.u, this.v + this.dz + dy00, this.u + this.dz, this.v + this.dz + this.dy0);
            this.vs.put(8, new PositionTextureVertex(this.xe, g0.field_189982_i, g0.field_189983_j, 0.0f, 0.0f));
            this.vs.put(9, new PositionTextureVertex(this.x, g0.field_189982_i, g0.field_189983_j, 0.0f, 8.0f));
            this.setQuard(i++, this.vs.get(7), this.vs.get(6), this.vs.get(8), this.vs.get(9), this.u + 2.0f * (this.dz + this.dx), this.v + this.dz + dy00, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + dy00, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + dy01, this.u + 2.0f * (this.dz + this.dx), this.v + this.dz + dy01);
            this.setQuard(i++, this.vs.get(5), this.vs.get(6), this.vs.get(8), this.vs.get(5), this.u + this.dz + this.dx, this.v + this.dz + this.dy0, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + dy00, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + dy01, this.u + this.dz + this.dx, this.v + this.dz + this.dy0);
            this.setQuard(i++, this.vs.get(4), this.vs.get(7), this.vs.get(9), this.vs.get(4), this.u + this.dz, this.v + this.dz + this.dy0, this.u, this.v + this.dz + dy00, this.u, this.v + this.dz + dy01, this.u + this.dz, this.v + this.dz + this.dy0);
            this.vs.put(10, new PositionTextureVertex(this.xe, g1.field_189982_i, g1.field_189983_j, 0.0f, 0.0f));
            this.vs.put(11, new PositionTextureVertex(this.x, g1.field_189982_i, g1.field_189983_j, 0.0f, 8.0f));
            this.setQuard(i++, this.vs.get(9), this.vs.get(8), this.vs.get(10), this.vs.get(11), this.u + 2.0f * (this.dz + this.dx), this.v + this.dz + dy01, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + dy01, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + dy02, this.u + 2.0f * (this.dz + this.dx), this.v + this.dz + dy02);
            this.setQuard(i++, this.vs.get(5), this.vs.get(8), this.vs.get(10), this.vs.get(5), this.u + this.dz + this.dx, this.v + this.dz + this.dy0, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + dy01, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + dy02, this.u + this.dz + this.dx, this.v + this.dz + this.dy0);
            this.setQuard(i++, this.vs.get(4), this.vs.get(9), this.vs.get(11), this.vs.get(4), this.u + this.dz, this.v + this.dz + this.dy0, this.u, this.v + this.dz + dy01, this.u, this.v + this.dz + dy02, this.u + this.dz, this.v + this.dz + this.dy0);
            this.vs.put(12, new PositionTextureVertex(this.xe, g2.field_189982_i, g2.field_189983_j, 0.0f, 0.0f));
            this.vs.put(13, new PositionTextureVertex(this.x, g2.field_189982_i, g2.field_189983_j, 0.0f, 8.0f));
            this.setQuard(i++, this.vs.get(11), this.vs.get(10), this.vs.get(12), this.vs.get(13), this.u + 2.0f * (this.dz + this.dx), this.v + this.dz + dy02, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + dy02, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + dy03, this.u + 2.0f * (this.dz + this.dx), this.v + this.dz + dy03);
            this.setQuard(i++, this.vs.get(5), this.vs.get(10), this.vs.get(12), this.vs.get(5), this.u + this.dz + this.dx, this.v + this.dz + this.dy0, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + dy02, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + dy03, this.u + this.dz + this.dx, this.v + this.dz + this.dy0);
            this.setQuard(i++, this.vs.get(4), this.vs.get(11), this.vs.get(13), this.vs.get(4), this.u + this.dz, this.v + this.dz + this.dy0, this.u, this.v + this.dz + dy02, this.u, this.v + this.dz + dy03, this.u + this.dz, this.v + this.dz + this.dy0);
            Vec2f yz14 = this.rotate(cr, new Vec2f(this.ye1, this.tvs[0].field_189983_j), cos2, sin2);
            Vec2f yz15 = this.rotate(cr, new Vec2f(this.ye1, this.tvs[1].field_189983_j), cos2, sin2);
            Vec2f yz16 = this.rotate(cr, new Vec2f(this.ye1, this.tvs[2].field_189983_j), cos2, sin2);
            Vec2f yz17 = this.rotate(cr, new Vec2f(this.ye1, this.tvs[3].field_189983_j), cos2, sin2);
            this.vs.put(14, new PositionTextureVertex(this.tvs[0].field_189982_i, yz14.field_189982_i, yz14.field_189983_j, 0.0f, 0.0f));
            this.vs.put(15, new PositionTextureVertex(this.tvs[1].field_189982_i, yz15.field_189982_i, yz15.field_189983_j, 0.0f, 0.0f));
            this.vs.put(16, new PositionTextureVertex(this.tvs[2].field_189982_i, yz16.field_189982_i, yz16.field_189983_j, 0.0f, 0.0f));
            this.vs.put(17, new PositionTextureVertex(this.tvs[3].field_189982_i, yz17.field_189982_i, yz17.field_189983_j, 0.0f, 0.0f));
            if (counterClockWise) {
                this.setQuard(i++, this.vs.get(5), this.vs.get(4), this.vs.get(15), this.vs.get(15), this.u + this.dz + this.dx, this.v + this.dz + this.dy0, this.u + this.dz, this.v + this.dz + this.dy0, this.u + this.dz + this.dx, this.v + this.dz + this.dy1, this.u + this.dz + this.dx, this.v + this.dz + this.dy1);
                this.setQuard(i++, this.vs.get(15), this.vs.get(4), this.vs.get(14), this.vs.get(14), this.u + this.dz + this.dx, this.v + this.dz + this.dy1, this.u + this.dz, this.v + this.dz + this.dy0, this.u + this.dz, this.v + this.dz + this.dy1, this.u + this.dz, this.v + this.dz + this.dy1);
                this.setQuard(i++, this.vs.get(13), this.vs.get(12), this.vs.get(17), this.vs.get(17), this.u + 2.0f * this.dz + this.dx, this.v + this.dz + dy03, this.u + 2.0f * (this.dz + this.dx), this.v + this.dz + this.dy1);
                this.setQuard(i++, this.vs.get(16), this.vs.get(17), this.vs.get(12), this.vs.get(16), this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy1, this.u + 2.0f * (this.dz + this.dx), this.v + this.dz + this.dy1, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + dy03, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy1);
                this.setQuard(i++, this.vs.get(16), this.vs.get(5), this.vs.get(15), this.vs.get(15), this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy1, this.u + this.dz + this.dx, this.v + this.dz + this.dy0, this.u + this.dz + this.dx, this.v + this.dz + this.dy1, this.u + this.dz + this.dx, this.v + this.dz + this.dy1);
                this.setQuard(i++, this.vs.get(12), this.vs.get(5), this.vs.get(16), this.vs.get(16), this.u + 2.0f * this.dz + this.dx, this.v + this.dz + dy03, this.u + this.dz + this.dx, this.v + this.dz + this.dy0, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy1, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy1);
                this.setQuard(i++, this.vs.get(4), this.vs.get(13), this.vs.get(14), this.vs.get(14), this.u + this.dz, this.v + this.dz + this.dy0, this.u, this.v + this.dz + dy03, this.u + this.dz, this.v + this.dz + this.dy1, this.u + this.dz, this.v + this.dz + this.dy1);
                this.setQuard(i++, this.vs.get(14), this.vs.get(13), this.vs.get(17), this.vs.get(17), this.u + this.dz, this.v + this.dz + this.dy1, this.u, this.v + this.dz + dy03, this.u, this.v + this.dz + this.dy1, this.u, this.v + this.dz + this.dy1);
            } else {
                this.setQuard(i++, this.vs.get(14), this.vs.get(15), this.vs.get(5), this.vs.get(5), this.u + this.dz, this.v + this.dz + this.dy1, this.u + this.dz + this.dx, this.v + this.dz + this.dy1, this.u + this.dz + this.dx, this.v + this.dz + dy03, this.u + this.dz + this.dx, this.v + this.dz + dy03);
                this.setQuard(i++, this.vs.get(5), this.vs.get(4), this.vs.get(14), this.vs.get(14), this.u + this.dz + this.dx, this.v + this.dz + dy03, this.u + this.dz, this.v + this.dz + dy03, this.u + this.dz, this.v + this.dz + this.dy1, this.u + this.dz, this.v + this.dz + this.dy1);
                this.setQuard(i++, this.vs.get(16), this.vs.get(17), this.vs.get(13), this.vs.get(13), this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy1, this.u + 2.0f * (this.dz + this.dx), this.v + this.dz + this.dy1, this.u + 2.0f * (this.dz + this.dx), this.v + this.dz + dy03, this.u + 2.0f * (this.dz + this.dx), this.v + this.dz + dy03);
                this.setQuard(i++, this.vs.get(13), this.vs.get(12), this.vs.get(16), this.vs.get(16), this.u + 2.0f * (this.dz + this.dx), this.v + this.dz + dy03, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + dy03, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy1, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy1);
                this.setQuard(i++, this.vs.get(12), this.vs.get(5), this.vs.get(15), this.vs.get(15), this.u + 2.0f * this.dz + this.dx, this.v + this.dz + dy03, this.u + this.dz + this.dx, this.v + this.dz + dy03, this.u + this.dz + this.dx, this.v + this.dz + this.dy1, this.u + this.dz + this.dx, this.v + this.dz + this.dy1);
                this.setQuard(i++, this.vs.get(15), this.vs.get(16), this.vs.get(12), this.vs.get(12), this.u + this.dz + this.dx, this.v + this.dz + this.dy1, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy1, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + dy03, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + dy03);
                this.setQuard(i++, this.vs.get(17), this.vs.get(14), this.vs.get(4), this.vs.get(4), this.u, this.v + this.dz + this.dy1, this.u + this.dz, this.v + this.dz + this.dy1, this.u + this.dz, this.v + this.dz + dy03, this.u + this.dz, this.v + this.dz + dy03);
                this.setQuard(i++, this.vs.get(4), this.vs.get(13), this.vs.get(17), this.vs.get(17), this.u + this.dz, this.v + this.dz + dy03, this.u, this.v + this.dz + dy03, this.u, this.v + this.dz + this.dy1, this.u, this.v + this.dz + this.dy1);
            }
            Vec2f yz18 = this.rotate(cr, new Vec2f(this.ye2, this.tvs[4].field_189983_j), cos2, sin2);
            Vec2f yz19 = this.rotate(cr, new Vec2f(this.ye2, this.tvs[5].field_189983_j), cos2, sin2);
            Vec2f yz20 = this.rotate(cr, new Vec2f(this.ye2, this.tvs[6].field_189983_j), cos2, sin2);
            Vec2f yz21 = this.rotate(cr, new Vec2f(this.ye2, this.tvs[7].field_189983_j), cos2, sin2);
            this.vs.put(18, new PositionTextureVertex(this.tvs[4].field_189982_i, yz18.field_189982_i, yz18.field_189983_j, 0.0f, 0.0f));
            this.vs.put(19, new PositionTextureVertex(this.tvs[5].field_189982_i, yz19.field_189982_i, yz19.field_189983_j, 0.0f, 0.0f));
            this.vs.put(20, new PositionTextureVertex(this.tvs[6].field_189982_i, yz20.field_189982_i, yz20.field_189983_j, 0.0f, 0.0f));
            this.vs.put(21, new PositionTextureVertex(this.tvs[7].field_189982_i, yz21.field_189982_i, yz21.field_189983_j, 0.0f, 0.0f));
        } else {
            Vec2f g0 = new Vec2f(cr.field_189982_i + (this.z - cr.field_189983_j) * sin0 + (this.ye0 - cr.field_189982_i) * cos0, cr.field_189983_j + (this.z - cr.field_189983_j) * cos0 - (this.ye0 - cr.field_189982_i) * sin0);
            Vec2f g1 = new Vec2f(cr.field_189982_i + (this.z - cr.field_189983_j) * sin1 + (this.ye0 - cr.field_189982_i) * cos1, cr.field_189983_j + (this.z - cr.field_189983_j) * cos1 - (this.ye0 - cr.field_189982_i) * sin1);
            Vec2f g2 = new Vec2f(cr.field_189982_i + (this.z - cr.field_189983_j) * sin2 + (this.ye0 - cr.field_189982_i) * cos2, cr.field_189983_j + (this.z - cr.field_189983_j) * cos2 - (this.ye0 - cr.field_189982_i) * sin2);
            float t = (this.ze - cr.field_189983_j) * tan;
            Vec2f g3 = new Vec2f(this.ye0 + t, this.ze);
            float d0 = (float)Math.hypot(g0.field_189982_i - g1.field_189982_i, g0.field_189983_j - g1.field_189983_j);
            float n0 = this.dy0 / (this.dy0 + d0 * 1.5f) * d0 * 1.5f;
            float n1 = (this.dy1 - this.dy0) / (this.dy1 - this.dy0 + d0 * 1.5f) * d0 * 1.5f;
            float dy00 = this.dy0 - n0;
            float dy01 = dy00 + n0 / 1.5f;
            float dy02 = this.dy0 + n1 / 3.0f;
            float dy03 = this.dy0 + n1;
            this.vs.put(4, new PositionTextureVertex(this.x, this.ye0, this.z, 0.0f, 0.0f));
            this.vs.put(5, new PositionTextureVertex(this.xe, this.ye0, this.z, 0.0f, 8.0f));
            this.vs.put(6, new PositionTextureVertex(this.xe, g3.field_189982_i, this.ze, 8.0f, 8.0f));
            this.vs.put(7, new PositionTextureVertex(this.x, g3.field_189982_i, this.ze, 8.0f, 0.0f));
            this.setQuard(i++, this.vs.get(1), this.vs.get(0), this.vs.get(4), this.vs.get(5), this.u + this.dz, this.v + this.dz, this.u + this.dz + this.dx, this.v + this.dz + dy00);
            this.setQuard(i++, this.vs.get(3), this.vs.get(2), this.vs.get(6), this.vs.get(7), this.u + 2.0f * this.dz + this.dx, this.v + this.dz, this.u + 2.0f * (this.dz + this.dx), this.v + this.dz + this.dy0);
            this.setQuard(i++, this.vs.get(1), this.vs.get(2), this.vs.get(6), this.vs.get(5), this.u + this.dz + this.dx, this.v + this.dz, this.u + 2.0f * this.dz + this.dx, this.v + this.dz, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy0, this.u + this.dz + this.dx, this.v + this.dz + dy00);
            this.setQuard(i++, this.vs.get(0), this.vs.get(3), this.vs.get(7), this.vs.get(4), this.u + this.dz, this.v + this.dz, this.u, this.v + this.dz, this.u, this.v + this.dz + this.dy0, this.u + this.dz, this.v + this.dz + dy00);
            this.vs.put(8, new PositionTextureVertex(this.xe, g0.field_189982_i, g0.field_189983_j, 0.0f, 0.0f));
            this.vs.put(9, new PositionTextureVertex(this.x, g0.field_189982_i, g0.field_189983_j, 0.0f, 8.0f));
            this.setQuard(i++, this.vs.get(5), this.vs.get(4), this.vs.get(9), this.vs.get(8), this.u + this.dz + this.dx, this.v + this.dz + dy00, this.u + this.dz, this.v + this.dz + dy00, this.u + this.dz, this.v + this.dz + dy01, this.u + this.dz + this.dx, this.v + this.dz + dy01);
            this.setQuard(i++, this.vs.get(5), this.vs.get(6), this.vs.get(8), this.vs.get(5), this.u + this.dz + this.dx, this.v + this.dz + dy00, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy0, this.u + this.dz + this.dx, this.v + this.dz + dy01, this.u + this.dz + this.dx, this.v + this.dz + dy00);
            this.setQuard(i++, this.vs.get(4), this.vs.get(7), this.vs.get(9), this.vs.get(4), this.u + this.dz, this.v + this.dz + dy00, this.u, this.v + this.dz + this.dy0, this.u + this.dz, this.v + this.dz + dy01, this.u + this.dz, this.v + this.dz + dy00);
            this.vs.put(10, new PositionTextureVertex(this.xe, g1.field_189982_i, g1.field_189983_j, 0.0f, 0.0f));
            this.vs.put(11, new PositionTextureVertex(this.x, g1.field_189982_i, g1.field_189983_j, 0.0f, 8.0f));
            this.setQuard(i++, this.vs.get(8), this.vs.get(9), this.vs.get(11), this.vs.get(10), this.u + this.dz + this.dx, this.v + this.dz + dy01, this.u + this.dz, this.v + this.dz + dy01, this.u + this.dz, this.v + this.dz + dy02, this.u + this.dz + this.dx, this.v + this.dz + dy02);
            this.setQuard(i++, this.vs.get(8), this.vs.get(6), this.vs.get(10), this.vs.get(8), this.u + this.dz + this.dx, this.v + this.dz + dy01, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy0, this.u + this.dz + this.dx, this.v + this.dz + dy02, this.u + this.dz + this.dx, this.v + this.dz + dy01);
            this.setQuard(i++, this.vs.get(9), this.vs.get(7), this.vs.get(11), this.vs.get(9), this.u + this.dz, this.v + this.dz + dy01, this.u, this.v + this.dz + this.dy0, this.u + this.dz, this.v + this.dz + dy02, this.u + this.dz, this.v + this.dz + dy01);
            this.vs.put(12, new PositionTextureVertex(this.xe, g2.field_189982_i, g2.field_189983_j, 0.0f, 0.0f));
            this.vs.put(13, new PositionTextureVertex(this.x, g2.field_189982_i, g2.field_189983_j, 0.0f, 8.0f));
            this.setQuard(i++, this.vs.get(10), this.vs.get(11), this.vs.get(13), this.vs.get(12), this.u + this.dz + this.dx, this.v + this.dz + dy02, this.u + this.dz, this.v + this.dz + dy02, this.u + this.dz, this.v + this.dz + dy03, this.u + this.dz + this.dx, this.v + this.dz + dy03);
            this.setQuard(i++, this.vs.get(10), this.vs.get(6), this.vs.get(12), this.vs.get(10), this.u + this.dz + this.dx, this.v + this.dz + dy02, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy0, this.u + this.dz + this.dx, this.v + this.dz + dy03, this.u + this.dz + this.dx, this.v + this.dz + dy02);
            this.setQuard(i++, this.vs.get(11), this.vs.get(7), this.vs.get(13), this.vs.get(11), this.u + this.dz, this.v + this.dz + dy02, this.u, this.v + this.dz + this.dy0, this.u + this.dz, this.v + this.dz + dy03, this.u + this.dz, this.v + this.dz + dy02);
            Vec2f yz14 = this.rotate(cr, new Vec2f(this.ye1, this.tvs[0].field_189983_j), cos2, sin2);
            Vec2f yz15 = this.rotate(cr, new Vec2f(this.ye1, this.tvs[1].field_189983_j), cos2, sin2);
            Vec2f yz16 = this.rotate(cr, new Vec2f(this.ye1, this.tvs[2].field_189983_j), cos2, sin2);
            Vec2f yz17 = this.rotate(cr, new Vec2f(this.ye1, this.tvs[3].field_189983_j), cos2, sin2);
            this.vs.put(14, new PositionTextureVertex(this.tvs[0].field_189982_i, yz14.field_189982_i, yz14.field_189983_j, 0.0f, 0.0f));
            this.vs.put(15, new PositionTextureVertex(this.tvs[1].field_189982_i, yz15.field_189982_i, yz15.field_189983_j, 0.0f, 0.0f));
            this.vs.put(16, new PositionTextureVertex(this.tvs[2].field_189982_i, yz16.field_189982_i, yz16.field_189983_j, 0.0f, 0.0f));
            this.vs.put(17, new PositionTextureVertex(this.tvs[3].field_189982_i, yz17.field_189982_i, yz17.field_189983_j, 0.0f, 0.0f));
            if (counterClockWise) {
                this.setQuard(i++, this.vs.get(15), this.vs.get(12), this.vs.get(13), this.vs.get(15), this.u + this.dz + this.dx, this.v + this.dz + this.dy1, this.u + this.dz + this.dx, this.v + this.dz + dy03, this.u + this.dz, this.v + this.dz + dy03, this.u + this.dz + this.dx, this.v + this.dz + this.dy1);
                this.setQuard(i++, this.vs.get(15), this.vs.get(13), this.vs.get(14), this.vs.get(15), this.u + this.dz + this.dx, this.v + this.dz + this.dy1, this.u + this.dz, this.v + this.dz + dy03, this.u + this.dz, this.v + this.dz + this.dy1, this.u + this.dz + this.dx, this.v + this.dz + this.dy1);
                this.setQuard(i++, this.vs.get(7), this.vs.get(6), this.vs.get(17), this.vs.get(17), this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy0, this.u + 2.0f * (this.dz + this.dx), this.v + this.dz + this.dy1);
                this.setQuard(i++, this.vs.get(17), this.vs.get(6), this.vs.get(16), this.vs.get(17), this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy0, this.u + 2.0f * (this.dz + this.dx), this.v + this.dz + this.dy1);
                this.setQuard(i++, this.vs.get(6), this.vs.get(12), this.vs.get(16), this.vs.get(16), this.u + this.dz + this.dx, this.v + this.dz + dy03, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy1);
                this.setQuard(i++, this.vs.get(16), this.vs.get(12), this.vs.get(15), this.vs.get(16), this.u + this.dz + this.dx, this.v + this.dz + dy03, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy1);
                this.setQuard(i++, this.vs.get(13), this.vs.get(7), this.vs.get(14), this.vs.get(14), this.u, this.v + this.dz + dy03, this.u + this.dz, this.v + this.dz + this.dy1);
                this.setQuard(i++, this.vs.get(14), this.vs.get(7), this.vs.get(17), this.vs.get(14), this.u, this.v + this.dz + dy03, this.u + this.dz, this.v + this.dz + this.dy1);
            } else {
                this.setQuard(i++, this.vs.get(13), this.vs.get(12), this.vs.get(14), this.vs.get(14), this.u + this.dz + this.dx, this.v + this.dz + dy03, this.u + this.dz, this.v + this.dz + this.dy1);
                this.setQuard(i++, this.vs.get(14), this.vs.get(12), this.vs.get(15), this.vs.get(14), this.u + this.dz + this.dx, this.v + this.dz + dy03, this.u + this.dz, this.v + this.dz + this.dy1);
                this.setQuard(i++, this.vs.get(16), this.vs.get(7), this.vs.get(6), this.vs.get(16), this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy1, this.u + 2.0f * (this.dz + this.dx), this.v + this.dz + this.dy0, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy0, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy1);
                this.setQuard(i++, this.vs.get(7), this.vs.get(16), this.vs.get(17), this.vs.get(17), this.u + 2.0f * (this.dz + this.dx), this.v + this.dz + this.dy0, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy1, this.u + 2.0f * (this.dz + this.dx), this.v + this.dz + this.dy1, this.u + 2.0f * (this.dz + this.dx), this.v + this.dz + this.dy1);
                this.setQuard(i++, this.vs.get(6), this.vs.get(12), this.vs.get(15), this.vs.get(15), this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy0, this.u + this.dz + this.dx, this.v + this.dz + dy03, this.u + this.dz + this.dx, this.v + this.dz + this.dy1, this.u + this.dz + this.dx, this.v + this.dz + this.dy1);
                this.setQuard(i++, this.vs.get(16), this.vs.get(6), this.vs.get(15), this.vs.get(16), this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy1, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy0, this.u + this.dz + this.dx, this.v + this.dz + this.dy1, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy1);
                this.setQuard(i++, this.vs.get(13), this.vs.get(17), this.vs.get(14), this.vs.get(14), this.u + this.dz, this.v + this.dz + dy03, this.u, this.v + this.dz + this.dy1, this.u + this.dz, this.v + this.dz + this.dy1, this.u + this.dz, this.v + this.dz + this.dy1);
                this.setQuard(i++, this.vs.get(13), this.vs.get(7), this.vs.get(17), this.vs.get(17), this.u + this.dz, this.v + this.dz + dy03, this.u, this.v + this.dz + this.dy0, this.u, this.v + this.dz + this.dy1, this.u, this.v + this.dz + this.dy1);
            }
            Vec2f yz18 = this.rotate(cr, new Vec2f(this.ye2, this.tvs[4].field_189983_j), cos2, sin2);
            Vec2f yz19 = this.rotate(cr, new Vec2f(this.ye2, this.tvs[5].field_189983_j), cos2, sin2);
            Vec2f yz20 = this.rotate(cr, new Vec2f(this.ye2, this.tvs[6].field_189983_j), cos2, sin2);
            Vec2f yz21 = this.rotate(cr, new Vec2f(this.ye2, this.tvs[7].field_189983_j), cos2, sin2);
            this.vs.put(18, new PositionTextureVertex(this.tvs[4].field_189982_i, yz18.field_189982_i, yz18.field_189983_j, 0.0f, 0.0f));
            this.vs.put(19, new PositionTextureVertex(this.tvs[5].field_189982_i, yz19.field_189982_i, yz19.field_189983_j, 0.0f, 0.0f));
            this.vs.put(20, new PositionTextureVertex(this.tvs[6].field_189982_i, yz20.field_189982_i, yz20.field_189983_j, 0.0f, 0.0f));
            this.vs.put(21, new PositionTextureVertex(this.tvs[7].field_189982_i, yz21.field_189982_i, yz21.field_189983_j, 0.0f, 0.0f));
        }
        this.setQuard(i++, this.vs.get(15), this.vs.get(14), this.vs.get(18), this.vs.get(19), this.u + this.dz, this.v + this.dz + this.dy1, this.u + this.dz + this.dx, this.v + this.dz + this.dy2);
        this.setQuard(i++, this.vs.get(17), this.vs.get(16), this.vs.get(20), this.vs.get(21), this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy1, this.u + 2.0f * (this.dz + this.dx), this.v + this.dz + this.dy2);
        this.setQuard(i++, this.vs.get(16), this.vs.get(15), this.vs.get(19), this.vs.get(20), this.u + this.dz + this.dx, this.v + this.dz + this.dy1, this.u + 2.0f * this.dz + this.dx, this.v + this.dz + this.dy2);
        this.setQuard(i++, this.vs.get(14), this.vs.get(17), this.vs.get(21), this.vs.get(18), this.u, this.v + this.dz + this.dy1, this.u + this.dz, this.v + this.dz + this.dy2);
        this.setQuard(i, this.vs.get(19), this.vs.get(18), this.vs.get(21), this.vs.get(20), this.u + this.dz + this.dx, this.v, this.u + 2.0f * this.dz + this.dx, this.v + this.dz);
        this.draw(scale);
    }

    private void draw(float scale) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder br = tess.func_178180_c();
        for (TexturedQuad tq : this.quads.values()) {
            if (tq == null) continue;
            tq.func_178765_a(br, scale);
        }
    }

    private Vec2f rotate(Vec2f center, Vec2f vertex, double cos, double sin) {
        float y = (float)((double)center.field_189983_j + (double)(vertex.field_189983_j - center.field_189983_j) * cos - (double)(vertex.field_189982_i - center.field_189982_i) * sin);
        float x = (float)((double)center.field_189982_i + (double)(vertex.field_189983_j - center.field_189983_j) * sin + (double)(vertex.field_189982_i - center.field_189982_i) * cos);
        return new Vec2f(x, y);
    }

    private void setQuard(int i, PositionTextureVertex ptv0, PositionTextureVertex ptv1, PositionTextureVertex ptv2, PositionTextureVertex ptv3, float u1, float v1, float u2, float v2) {
        this.quads.put(i, new TexturedQuad(new PositionTextureVertex[]{ptv0, ptv1, ptv2, ptv3}));
        this.quads.get((Object)Integer.valueOf((int)i)).field_78239_a[0] = ptv0.func_78240_a(u2 / this.field_78801_a, v1 / this.field_78799_b);
        this.quads.get((Object)Integer.valueOf((int)i)).field_78239_a[1] = ptv1.func_78240_a(u1 / this.field_78801_a, v1 / this.field_78799_b);
        this.quads.get((Object)Integer.valueOf((int)i)).field_78239_a[2] = ptv2.func_78240_a(u1 / this.field_78801_a, v2 / this.field_78799_b);
        this.quads.get((Object)Integer.valueOf((int)i)).field_78239_a[3] = ptv3.func_78240_a(u2 / this.field_78801_a, v2 / this.field_78799_b);
    }

    private void setQuard(int i, PositionTextureVertex ptv0, PositionTextureVertex ptv1, PositionTextureVertex ptv2, PositionTextureVertex ptv3, float u0, float v0, float u1, float v1, float u2, float v2, float u3, float v3) {
        this.quads.put(i, new TexturedQuad(new PositionTextureVertex[]{ptv0, ptv1, ptv2, ptv3}));
        this.quads.get((Object)Integer.valueOf((int)i)).field_78239_a[0] = ptv0.func_78240_a(u0 / this.field_78801_a, v0 / this.field_78799_b);
        this.quads.get((Object)Integer.valueOf((int)i)).field_78239_a[1] = ptv1.func_78240_a(u1 / this.field_78801_a, v1 / this.field_78799_b);
        this.quads.get((Object)Integer.valueOf((int)i)).field_78239_a[2] = ptv2.func_78240_a(u2 / this.field_78801_a, v2 / this.field_78799_b);
        this.quads.get((Object)Integer.valueOf((int)i)).field_78239_a[3] = ptv3.func_78240_a(u3 / this.field_78801_a, v3 / this.field_78799_b);
    }

    public void setIsNormal(boolean bo) {
        this.isNormal = bo;
    }

    public void copyModelAngles(ModelRendererAlt source) {
        this.field_78795_f = source.field_78795_f;
        this.field_78796_g = source.field_78796_g;
        this.field_78808_h = source.field_78808_h;
        this.field_78800_c = source.field_78800_c;
        this.field_78797_d = source.field_78797_d;
        this.field_78798_e = source.field_78798_e;
        this.rotateAngleX1 = source.rotateAngleX1;
        this.rotateAngleY1 = source.rotateAngleY1;
        this.scaleX = source.scaleX;
        this.scaleY = source.scaleY;
        this.scaleZ = source.scaleZ;
        this.offsetAnimX = source.offsetAnimX;
        this.offsetAnimY = source.offsetAnimY;
        this.offsetAnimZ = source.offsetAnimZ;
    }

    public void checkBacklightColor(float red, float green, float blue) {
        this.r = red;
        this.g = green;
        this.b = blue;
        this.al = 1.0f;
        if (ModelNpcAlt.editAnimDataSelect.isNPC) {
            if (ModelNpcAlt.editAnimDataSelect.part == this.part.patterns) {
                this.r = ModelNpcAlt.editAnimDataSelect.red;
                this.g = ModelNpcAlt.editAnimDataSelect.green;
                this.b = ModelNpcAlt.editAnimDataSelect.blue;
            } else {
                this.al = ModelNpcAlt.editAnimDataSelect.alpha;
            }
        }
        if (this.field_78805_m != null) {
            for (ModelRenderer modelRenderer : this.field_78805_m) {
                if (!(modelRenderer instanceof ModelRendererAlt)) continue;
                ((ModelRendererAlt)modelRenderer).checkBacklightColor(this.r, this.g, this.b);
            }
        }
    }

    public void clearOBJ() {
        if (this.displayOBJListUp > 0) {
            this.displayOBJListUp = -1;
        }
        if (this.displayOBJListDown > 0) {
            this.displayOBJListDown = -1;
        }
    }

    public void setOBJModel(ItemStack stack, EnumParts part) {
        ResourceLocation mainTexture;
        if (stack == null || !(stack.func_77973_b() instanceof CustomArmor)) {
            this.displayOBJListUp = 0;
            this.displayOBJListDown = 0;
            return;
        }
        CustomArmor armor = (CustomArmor)stack.func_77973_b();
        HashMap<String, String> map = null;
        if (stack.func_77942_o() && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("OBJTexture") && (mainTexture = ModelBuffer.getMainOBJTexture(armor.objModel)) != null) {
            map = new HashMap<String, String>();
            map.put(mainTexture.toString(), stack.func_77978_p().func_74779_i("OBJTexture"));
        }
        if (this.part == EnumParts.LEG_RIGHT && part == EnumParts.FEET_RIGHT || this.part == EnumParts.LEG_LEFT && part == EnumParts.FEET_LEFT) {
            this.displayOBJListDown = ModelBuffer.getDisplayList(armor.objModel, armor.getMeshNames(part), map);
        } else {
            this.displayOBJListUp = ModelBuffer.getDisplayList(armor.objModel, armor.getMeshNames(part != null ? part : this.part), map);
            switch (this.part) {
                case ARM_RIGHT: {
                    this.displayOBJListDown = ModelBuffer.getDisplayList(armor.objModel, armor.getMeshNames(EnumParts.WRIST_RIGHT), map);
                    break;
                }
                case ARM_LEFT: {
                    this.displayOBJListDown = ModelBuffer.getDisplayList(armor.objModel, armor.getMeshNames(EnumParts.WRIST_LEFT), map);
                    break;
                }
                case LEG_RIGHT: {
                    this.displayOBJListDown = ModelBuffer.getDisplayList(armor.objModel, armor.getMeshNames(EnumParts.FOOT_RIGHT), map);
                    break;
                }
                case LEG_LEFT: {
                    this.displayOBJListDown = ModelBuffer.getDisplayList(armor.objModel, armor.getMeshNames(EnumParts.FOOT_LEFT), map);
                    break;
                }
            }
        }
    }

    public boolean notOBJModel() {
        return this.displayOBJListUp <= 0 && this.displayOBJListDown <= 0;
    }

    public void setBaseData(ModelPartConfig config) {
        if (config == null) {
            this.offsetAnimX = 0.0f;
            this.offsetAnimY = 0.0f;
            this.offsetAnimZ = 0.0f;
            this.scaleX = 1.0f;
            this.scaleY = 1.0f;
            this.scaleZ = 1.0f;
            return;
        }
        this.offsetAnimX = config.offset[0];
        this.offsetAnimY = config.offset[1];
        this.offsetAnimZ = config.offset[2];
        this.scaleX = config.scale[0];
        this.scaleY = config.scale[1];
        this.scaleZ = config.scale[2];
    }

    public void putAnimation(DataAnimation animation) {
        AnimationFrameConfig preFrame = animation.getPreFrame();
        if (preFrame == null || !preFrame.parts.containsKey(this.partId)) {
            return;
        }
        preFrame.parts.get((Object)Integer.valueOf((int)this.partId)).show = this.field_78806_j;
        preFrame.parts.get((Object)Integer.valueOf((int)this.partId)).rotation[0] = this.field_78795_f;
        preFrame.parts.get((Object)Integer.valueOf((int)this.partId)).rotation[1] = this.field_78796_g;
        preFrame.parts.get((Object)Integer.valueOf((int)this.partId)).rotation[2] = this.field_78808_h;
        preFrame.parts.get((Object)Integer.valueOf((int)this.partId)).rotation[3] = this.rotateAngleX1;
        preFrame.parts.get((Object)Integer.valueOf((int)this.partId)).rotation[4] = this.rotateAngleY1;
        preFrame.parts.get((Object)Integer.valueOf((int)this.partId)).offset[0] = this.offsetAnimX;
        preFrame.parts.get((Object)Integer.valueOf((int)this.partId)).offset[1] = this.offsetAnimY;
        preFrame.parts.get((Object)Integer.valueOf((int)this.partId)).offset[2] = this.offsetAnimZ;
        preFrame.parts.get((Object)Integer.valueOf((int)this.partId)).scale[0] = this.scaleX;
        preFrame.parts.get((Object)Integer.valueOf((int)this.partId)).scale[1] = this.scaleY;
        preFrame.parts.get((Object)Integer.valueOf((int)this.partId)).scale[2] = this.scaleZ;
    }

    public void setAnimation(Float[] partSets) {
        if (partSets == null) {
            return;
        }
        this.field_78795_f = partSets[0].floatValue();
        this.field_78796_g = partSets[1].floatValue();
        this.field_78808_h = partSets[2].floatValue();
        this.offsetAnimX += partSets[3].floatValue();
        this.offsetAnimY += partSets[4].floatValue();
        this.offsetAnimZ += partSets[5].floatValue();
        this.scaleX *= partSets[6].floatValue();
        this.scaleY *= partSets[7].floatValue();
        this.scaleZ *= partSets[8].floatValue();
        if (partSets[9].floatValue() != 0.0f || partSets[10].floatValue() != 0.0f) {
            this.rotateAngleX1 = partSets[9].floatValue();
            this.rotateAngleY1 = partSets[10].floatValue();
            if (this.isNormal) {
                this.isNormal = false;
            }
        }
        this.isAnimPart = partSets[0].floatValue() != 0.0f || partSets[1].floatValue() != 0.0f || partSets[2].floatValue() != 0.0f || partSets[3].floatValue() != 0.0f || partSets[4].floatValue() != 0.0f || partSets[5].floatValue() != 0.0f || partSets[6].floatValue() != 1.0f || partSets[7].floatValue() != 1.0f || partSets[8].floatValue() != 1.0f || partSets[9].floatValue() != 0.0f || partSets[10].floatValue() != 0.0f;
    }

    public void setAnimation(DataAnimation animation) {
        if (!this.field_78806_j) {
            return;
        }
        this.field_78806_j = animation.getAnimationPartShow(this.partId);
        if (!this.field_78806_j) {
            return;
        }
        this.setAnimation(animation.getAnimationPartData(this.partId));
    }

    public void func_78793_a(float rotationPointXIn, float rotationPointYIn, float rotationPointZIn) {
        this.field_78800_c = rotationPointXIn;
        this.field_78797_d = rotationPointYIn;
        this.field_78798_e = rotationPointZIn;
        this.baseRotationPoint[0] = rotationPointXIn;
        this.baseRotationPoint[1] = rotationPointYIn;
        this.baseRotationPoint[2] = rotationPointZIn;
    }

    public void clearRotations() {
        this.field_78800_c = this.baseRotationPoint[0];
        this.field_78797_d = this.baseRotationPoint[1];
        this.field_78798_e = this.baseRotationPoint[2];
        this.field_78795_f = 0.0f;
        this.field_78796_g = 0.0f;
        this.field_78808_h = 0.0f;
        this.rotateAngleX1 = 0.0f;
        this.rotateAngleY1 = 0.0f;
        this.offsetAnimX = 0.0f;
        this.offsetAnimY = 0.0f;
        this.offsetAnimZ = 0.0f;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.scaleZ = 1.0f;
        this.isAnimPart = false;
        this.field_78806_j = true;
        this.isNormal = this.baseNormal;
    }

    @Override
    public boolean isShowModel() {
        return this.field_78806_j;
    }

    @Override
    public float[] getRotations() {
        return new float[]{this.field_78795_f, this.field_78796_g, this.field_78808_h, this.rotateAngleX1, this.rotateAngleY1};
    }

    @Override
    public float[] getOffsets() {
        return new float[]{this.offsetAnimX, this.offsetAnimY, this.offsetAnimZ};
    }

    @Override
    public float[] getScales() {
        return new float[]{this.scaleX, this.scaleY, this.scaleZ};
    }
}

